#if defined _ability_levels_included
	#endinput
#endif
#define _ability_levels_included


/********************************************************/


// Возвращает максимальный уровень. Уровни начинаются с 1.
native AL_GetMaxLevel();

// Получить имя уровня/класса. maxlength 65.
native bool:AL_GetLevelName(level, String:buffer[], maxlength);

// Сколько требуется очков для достижения уровня.
// В случае успеха вернет 0 или больше; если ошибка: -1.
native AL_GetLevelPoints(level);

// Вернет true, если игрок авторизован и все его данные были загружены из SQL.
native bool:AL_IsClientAuthorized(client);

// Узнать сколько у игрока очков.
native AL_GetClientPoints(client);

// Установить очки игроку.
native bool:AL_SetClientPoints(client, points);

// На каком уровне игрок (последний достигнутый).
native AL_GetClientLevel(client);

// Текущий уровень/класс игрока. У каждого уровня свои способности.
// Например, если игрок достиг третьего, то он может выбрать и второй и первый, если захочет.
native AL_GetClientActiveLevel(client);

// Узнать на каком игрок месте в топе.
// Если очков у игрока < 1 или событие AL_Event_TopUpdated еще не сработало, то вернет 0.
native AL_GetTopPlace(client);

// То же самое, что и AL_GetTopPlace, только вместо client -> steamid.
native AL_GetTopPlaceBySteam(const String:steamid[]);

// Получить стим игрока из топа. place - место в топе от 1 до 9.
native bool:AL_GetSteamByTopPlace(place, String:buffer[], maxlength);

// Сколько всего игроков в базе.
// Если AL_Event_TopUpdated еще не сработало, вернет 0.
native AL_GetDbPlayersCount();


/********************************************************/


/**
 * ИРОК АВТОРИЗОВАН.
 * 
 * points			- очки игрока
 * level			- последний достигнутый уровень
 * active_level		- текущий уровень/класс игрока (подробнее см. AL_GetClientActiveLevel)
**/
forward AL_Event_ClientAuthorized(client, const String:steamid[], points, level, active_level);

/**
 * УРОВЕНЬ ИГРОКА ИЗМЕНЕН.
 * 
 * old_level		- прошлый уровень
 * new_level		- новый
 * active_level		- текущий уровень/класс игрока (подробнее см. AL_GetClientActiveLevel)
**/
forward AL_Event_LevelChanged(client, old_level, new_level, active_level);

/**
 * ИГРОК ХОЧЕТ СМЕНИТЬ КЛАСС/УРОВЕНЬ (подробнее см. AL_GetClientActiveLevel)
 * 
 * old_active_level	- прошлый уровень
 * new_active_level	- новый
 * return Plugin_Continue (разрешить); return Plugin_Stop (запретить); 
**/
forward Action:AL_OnClientChangeActiveLevel(client, old_active_level, new_active_level);

/**
 * ТОП ОБНОВЛЕН (каждый раз после смены карты).
**/
forward AL_Event_TopUpdated();

/**
 * КРЕДИТЫ ИГРОКА СЕЙЧАС ИЗМЕНЯТСЯ
 * 
 * return Plugin_Continue (разрешить); return Plugin_Stop (запретить); return Plugin_Changed (изменить new_credits);
**/
forward Action:AL_OnClientCreditsChanged(client, old_credits, &new_credits);
